// *******************************************
// My Awesome Extension
// *******************************************

function MyAwesomeExtension(viewer, options) {
    Autodesk.Viewing.Extension.call(this, viewer, options);
    this.panel = null;
}

MyAwesomeExtension.prototype = Object.create(Autodesk.Viewing.Extension.prototype);
MyAwesomeExtension.prototype.constructor = MyAwesomeExtension;

MyAwesomeExtension.prototype.load = function () {
    if (this.viewer.toolbar) {
        // Toolbar is already available, create the UI
        this.createUI();
    } else {
        // Toolbar hasn't been created yet, wait until we get notification of its creation
        this.onToolbarCreatedBinded = this.onToolbarCreated.bind(this);
        this.viewer.addEventListener(Autodesk.Viewing.TOOLBAR_CREATED_EVENT, this.onToolbarCreatedBinded);
    }
    return true;
};

MyAwesomeExtension.prototype.onToolbarCreated = function () {
    this.viewer.removeEventListener(Autodesk.Viewing.TOOLBAR_CREATED_EVENT, this.onToolbarCreatedBinded);
    this.onToolbarCreatedBinded = null;
    this.createUI();
};

MyAwesomeExtension.prototype.createUI = function () {
    
        var viewer = this.viewer;
        var panel = this.panel;
        var legandpanel = this.panel;

    // button to show the docking panel
    var toolbarButtonShowDockingPanel = new Autodesk.Viewing.UI.Button('showMyAwesomePanel');
    var download2d = new Autodesk.Viewing.UI.Button('showSaveAs');
    
    download2d.onClick = function(e){
        if( myfilterpanel === undefined){
            myfilterpanel = new filterpanel(viewer,NOP_VIEWER.container,'filterpanel','Filters');
            myfilterpanel.setVisible(true);
          filterByAttr();
          }else{
              myfilterpanel.setVisible(true);
          }
    }
    
    toolbarButtonShowDockingPanel.onClick = function (e) {
        // if null, create it
        if (panel === null) {
            
            panel = new progress(viewer, viewer.container, 
                'ProgressCollector', 'Progress');
                
            legandpanel = new legands(viewer,viewer.container,'LegendsPanel','Legends');
        }
        // show/hide docking panel
        panel.setVisible(!panel.isVisible());
        legandpanel.setVisible(!legandpanel.isVisible());
        progressClicked = !progressClicked;
        console.log(progressClicked);
        setGrayModel();
        //keepGrids();
        
    };
    
    
    //toolbarButtonShowDockingPanel.addClass('myAwesomeToolbarButton');
    toolbarButtonShowDockingPanel.setToolTip('Progress');
    download2d.setToolTip('Save As');
    download2d.container.children[0].innerHTML = '<i class="fa fa-filter" aria-hidden="true"></i>';


    // SubToolbar
    this.subToolbar = new Autodesk.Viewing.UI.ControlGroup('MyAwesomeAppToolbar');
    this.subToolbar1 = new Autodesk.Viewing.UI.ControlGroup('saveASToolbar');
    this.subToolbar.addControl(toolbarButtonShowDockingPanel);
    this.subToolbar1.addControl(download2d);
    viewer.toolbar.addControl(this.subToolbar);
    viewer.toolbar.addControl(this.subToolbar1);

};

MyAwesomeExtension.prototype.unload = function () {
    this.viewer.toolbar.removeControl(this.subToolbar);
    return true;
};

Autodesk.Viewing.theExtensionManager.registerExtension('MyAwesomeExtension', MyAwesomeExtension);


// *******************************************
// BOQPanel Panel
// *******************************************


function BOQPanel(viewer, container, id, title, options) {
    this.viewer = viewer;
    Autodesk.Viewing.UI.DockingPanel.call(this, container, id, title, options);
    
    
    
    this.container.style.top =  "0px";
    this.container.style.right = "0px";
    this.container.style.width = "450px";
    this.container.style.height = "100vh";
    this.container.style.resize = "none";



    // this is where we should place the content of our panel

    // and may also append child elements...
    var op = {};
            this.scrollcontainer = this.createScrollContainer(op);
            
            var html = [
'<table class="table table-dark table-hover tableFixHead" style="background:rgba(34,34,34,0.1)">',
'<thead>',
'<tr>',
'<th scope="col" style="background:rgba(34,34,34,1)">LEVEL</th>',
'<th scope="col" style="background:rgba(34,34,34,1)">BOQ Code</th>',
'<th scope="col" style="background:rgba(34,34,34,1)">BOQ Descreption</th>',
'<th scope="col" style="background:rgba(34,34,34,1)">Unit</th>',
'<th scope="col" style="background:rgba(34,34,34,1)">Quantites</th>',
'</tr>',
'</thead>',
'<tbody style="cursor: pointer;">',
'<tr onclick="applyBOQfilter(\'01\',\'P2.J.070.A\')">',
'<th scope="row">01</th>',
'<td>P2.J.070.A</td>',
'<td>Finishing; Flooring - Epoxy Coating Type FLH-801, Internal sidewalk/walkway</td>',
'<td>m²</td>',
'<td>3723.3</td>',
'</tr>',
'<tr onclick="applyBOQfilter(\'01\',\'P2.J.070.B\')">',
'<th scope="row">01</th>',
'<td>P2.J.070.B</td>',
'<td>Finishing; Flooring - Epoxy Coating Type FLH-802, External sidewalk/walkway</td>',
'<td>m²</td>',
'<td>487.3</td>',
'</tr>',
'<tr onclick="applyBOQfilter(\'01\',\'P2.J.070.C\')">',
'<th scope="row">01</th>',
'<td>P2.J.070.C</td>',
'<td>Finishing; Flooring - "Traffic Coating, Internal" Type FLH-801</td>',
'<td>m²</td>',
'<td>89340.6</td>',
'</tr>',
'<tr><td></td><td></td><td></td><td></td><td></td></tr>',
'<tr onclick="applyBOQfilter(\'02\',\'P2.J.070.A\')">',
'<th scope="row">02</th>',
'<td>P2.J.070.A</td>',
'<td>Finishing; Flooring - Epoxy Coating Type FLH-801, Internal sidewalk/walkway</td>',
'<td>m²</td>',
'<td>2714.4</td>',
'</tr>',
'<tr onclick="applyBOQfilter(\'02\',\'P2.J.070.B\')">',
'<th scope="row">02</th>',
'<td>P2.J.070.B</td>',
'<td>Finishing; Flooring - Epoxy Coating Type FLH-802, External sidewalk/walkway</td>',
'<td>m²</td>',
'<td>703.9</td>',
'</tr>',
'<tr onclick="applyBOQfilter(\'02\',\'P2.J.070.C\')">',
'<th scope="row">02</th>',
'<td>P2.J.070.C</td>',
'<td>Finishing; Flooring - "Traffic Coating, Internal" Type FLH-801</td>',
'<td>m²</td>',
'<td>31349.8</td>',
'</tr>',
'<tr onclick="applyBOQfilter(\'02\',\'P2.J.070.D\')">',
'<th scope="row">02</th>',
'<td>P2.J.070.D</td>',
'<td>Finishing; Flooring - "Traffic Coating, External" Type FLH-802</td>',
'<td>m²</td>',
'<td>4287.9</td>',
'</tr>',
'<tr><td></td><td></td><td></td><td></td><td></td></tr>',
'<tr onclick="applyBOQfilter(\'03\',\'P2.J.070.B\')">',
'<th scope="row">03</th>',
'<td>P2.J.070.B</td>',
'<td>Finishing; Flooring - Epoxy Coating Type FLH-802, External sidewalk/walkway</td>',
'<td>m²</td>',
'<td>2701.4</td>',
'</tr>',
'<tr onclick="applyBOQfilter(\'03\',\'P2.J.070.D\')">',
'<th scope="row">03</th>',
'<td>P2.J.070.D</td>',
'<td>Finishing; Flooring - "Traffic Coating, External" Type FLH-802</td>',
'<td>m²</td>',
'<td>34020.8</td>',
'</tr>',
'<tr><td></td><td></td><td></td><td></td><td></td></tr>',
'<tr onclick="applyBOQfilter(\'TBD\',\'P2.J.070.B\')">',
'<th scope="row">TBD</th>',
'<td>P2.J.070.B</td>',
'<td>Finishing; Flooring - Epoxy Coating Type FLH-802, External sidewalk/walkway</td>',
'<td>m²</td>',
'<td>193.4</td>',
'</tr>',
'<tr><td></td><td></td><td></td><td></td><td></td></tr>',
'<tr onclick="applyBOQfilter(\'U2\',\'P2.J.070.A\')">',
'<th scope="row">U2</th>',
'<td>P2.J.070.A</td>',
'<td>Finishing; Flooring - Epoxy Coating Type FLH-801, Internal sidewalk/walkway</td>',
'<td>m²</td>',
'<td>2340.6</td>',
'</tr>',
'<tr onclick="applyBOQfilter(\'U2\',\'P2.J.070.C\')">',
'<th scope="row">U2</th>',
'<td>P2.J.070.C</td>',
'<td>Finishing; Flooring - "Traffic Coating, Internal" Type FLH-801</td>',
'<td>m²</td>',
'<td>32743.6</td>',
'</tr>',
'<tr><td></td><td></td><td></td><td></td><td></td></tr>',
'<tr style="background:rgba(34,34,34,1)">',
'<th scope="row">Grand Total</th>',
'<td></td>',
'<td></td>',
'<td>m²</td>',
'<td>204606.9</td>',
'</tr>',
'<tr><td></td><td></td><td></td><td></td><td></td></tr>',
'<tr><td></td><td></td><td></td><td></td><td></td></tr>',
'</tbody>',
'</table>',
].join('\n');


$(this.scrollContainer).append(html);

this.footer = this.createFooter();
$(this.footer).append('<div class="docking-panel-version-label">by Udwan</div>');
}

function progress(viewer, container, id, title, options) {
    this.viewer = viewer;
    Autodesk.Viewing.UI.DockingPanel.call(this, container, id, title, options);
    // the style of the docking panel
    // use this built-in style to support Themes on Viewer 4+
    
   
   this.title.remove();
   this.closer.remove();
   this.footer.remove();
    
    var btTop = document.getElementById('showMyAwesomePanel').offsetParent.offsetTop - 50;
    var btleft = document.getElementById('showMyAwesomePanel').offsetLeft + 4;
    
    this.container.style.top = btTop + "px";
    this.container.style.left = btleft + "px";
    this.container.style.width = "7.5rem";
    this.container.style.height = "auto";
    this.container.style.resize = "none";



    // this is where we should place the content of our panel

    // and may also append child elements...
    var op = {};
            this.scrollcontainer = this.createScrollContainer(op);
            
            var html = [
                
  '<div class="input-group">',
  '<input id="progress_input" type="number" min="0" max="100" class="_form-control form-control" placeholder="%">',
  '<div class="input-group-append">',
    '<button onclick="setProgress()" class="btn btn-outline-secondary" type="button" id="button-addon2">add</button>',
  '</div>',
'</div>',

  

].join('\n');


$(this.scrollContainer).append(html);


}


// legands panel 

function legands(viewer, container, id, title, options) {
    this.viewer = viewer;
    Autodesk.Viewing.UI.DockingPanel.call(this, container, id, title, options);
    
    
    
    this.container.style.top =  "0px";
    this.container.style.left = "0px";
    this.container.style.width = "auto";
    this.container.style.height = "auto";
    this.container.style.resize = "none";



    // this is where we should place the content of our panel

    // and may also append child elements...
    var op = {};
            this.scrollcontainer = this.createScrollContainer(op);
            
            var html = [
                
                '<table class="table table-dark" style="background:rgba(34,34,34,0.1)">',
                '<tr>',
                '<td><div style = "background-color:rgb(150,150,150);width:20px;height:20px;"></div></td>',
                '<td>No Progress</td>',
                '</tr>',
                
                '<tr>',
                '<td><div style = "background-color:rgb(255,0,0);width:20px;height:20px;"></div></td>',
                '<td>1% - 24% in Progress</td>',
                '</tr>',
                
                '<tr>',
                '<td><div style = "background-color:rgb(255,165,0);width:20px;height:20px;"></div></td>',
                '<td>25% - 49% in Progress</td>',
                '</tr>',
                
                '<tr>',
                '<td><div style = "background-color:rgb(254,238,0);width:20px;height:20px;"></div></td>',
                '<td>50% - 69% in Progress</td>',
                '</tr>',
                
                '<tr>',
                '<td><div style = "background-color:rgb(173,255,47);width:20px;height:20px;"></div></td>',
                '<td>70% - 89% in Progress</td>',
                '</tr>',
                
                '<tr>',
                '<td><div style = "background-color:rgb(124,252,0);width:20px;height:20px;"></div></td>',
                '<td>90% - 99% in Progress</td>',
                '</tr>',
                
                '<tr>',
                '<td><div style = "background-color:rgb(0,255,0);width:20px;height:20px;"></div></td>',
                '<td>100% Completed</td>',
                '</tr>',
                '</table>',
                
].join('\n');


$(this.scrollContainer).append(html);

this.footer = this.createFooter();
$(this.footer).append('<div class="docking-panel-version-label">by Udwan</div>');
}


function GrandTotalPanel(viewer, container, id, title, options) {
    this.viewer = viewer;
    Autodesk.Viewing.UI.DockingPanel.call(this, container, id, title, options);


   this.title.remove();
   this.closer.remove();
   this.footer.remove();
    
    this.container.style.bottom =  "20px";
    this.container.style.left = "0px";
    this.container.style.width = "auto";
    this.container.style.height = "auto";
    this.container.style.resize = "none";



    // this is where we should place the content of our panel

    // and may also append child elements...
    var op = {};
            this.scrollcontainer = this.createScrollContainer(op);
            
            var html = [
                
                '<table class="table table-sm table-borderless table-dark" style="background:rgba(34,34,34,0)">',
                '<tr>',
                '<td>Area</td>',
                '<td id="grandtotArea"></td>',
                '</tr>',
                
                '<tr>',
                '<td>Volume</td>',
                '<td id="grandtotVolume"></td>',
                '</tr>',
                
                '<tr>',
                '<td>Length</td>',
                '<td id="grandtotLength"></td>',
                '</tr>',
                
                '</table>',
                
].join('\n');


$(this.scrollContainer).append(html);
/*
this.footer = this.createFooter();
$(this.footer).append('<div class="docking-panel-version-label">by Udwan</div>');
*/
}

function filterpanel(viewer, container, id, title, options) {
    this.viewer = viewer;
    Autodesk.Viewing.UI.DockingPanel.call(this, container, id, title, options);
    // the style of the docking panel
    // use this built-in style to support Themes on Viewer 4+
    //this.container.classList.add('docking-panel-scroll docking-panel-container-solid-color-a right');
    var vtoolbar = document.getElementById('divToolbar');
    var mytopoffset = 10;
    
    
    this.container.style.top = mytopoffset.toString() + "px";
    this.container.style.left = "70px";
    this.container.style.width = "auto";
    this.container.style.height = "auto";
    this.container.style.resize = "none";



    // this is where we should place the content of our panel

    // and may also append child elements...
    var op = {};
            this.scrollcontainer = this.createScrollContainer(op);
            
            var html = [


'<div class="table-wrapper-scroll-y">',
    '<table class="table table-borderless table-dark mb-0" style="background:rgba(34,34,34,0.1);">',
  '<thead>',
    '<tr>',
      '<th style="width:70px" scope="col">Attribute</th>',
      '<th style="width:70px" scope="col">conditions</th>',
      '<th style="width:150px" scope="col">Value</th>',
      '<th scope="col"></th>',
    '</tr>',
  '</thead>',
  '<tbody id="filtertable">',
  '<tr><td><select id="attr_List" style="width:70px" class="form-control form-control-sm" ></select></td>',
  '<td><select id = "oprator_List" style="width:70px" class="form-control form-control-sm"></select></td>',
  '<td><input id = "Attr_value" style="width:150px" class="form-control form-control-sm"></select></td>',
  '<td><button onclick="addtomytable()" type="button" class="btn btn-dark "><i class="fa fa-plus-circle fa-lg"></i></button></td></tr>',
    '</tbody>',
'</table>',
'</div>',

'<button onclick="applyfilter()" type="button" class="btn btn-success btn-sm btn-block">Apply</button>',
].join('\n');


$(this.scrollContainer).append(html);

//this.footer = this.createFooter();
//            $(this.footer).append('<div class="docking-panel-version-label">by Udwan</div>');
}

BOQPanel.prototype = Object.create(Autodesk.Viewing.UI.DockingPanel.prototype);
BOQPanel.prototype.constructor = BOQPanel;

progress.prototype = Object.create(Autodesk.Viewing.UI.DockingPanel.prototype);
progress.prototype.constructor = progress;

legands.prototype = Object.create(Autodesk.Viewing.UI.DockingPanel.prototype);
legands.prototype.constructor = legands;

GrandTotalPanel.prototype = Object.create(Autodesk.Viewing.UI.DockingPanel.prototype);
GrandTotalPanel.prototype.constructor = GrandTotalPanel;

filterpanel.prototype = Object.create(Autodesk.Viewing.UI.DockingPanel.prototype);
filterpanel.prototype.constructor = filterpanel;
