// *******************************************
// Panel Extension
// *******************************************
function panelExt(viewer, options) {
    Autodesk.Viewing.Extension.call(this, viewer, options);
    this.panel = null;
}

panelExt.prototype = Object.create(Autodesk.Viewing.Extension.prototype);
panelExt.prototype.constructor = panelExt;

panelExt.prototype.load = function () {
    if (this.viewer.toolbar) {
        // Toolbar is already available, create the UI
        this.createUI();
    } else {
        // Toolbar hasn't been created yet, wait until we get notification of its creation
        this.onToolbarCreatedBinded = this.onToolbarCreated.bind(this);
        this.viewer.addEventListener(Autodesk.Viewing.TOOLBAR_CREATED_EVENT, this.onToolbarCreatedBinded);
    }
    return true;
};

panelExt.prototype.onToolbarCreated = function () {
    this.viewer.removeEventListener(Autodesk.Viewing.TOOLBAR_CREATED_EVENT, this.onToolbarCreatedBinded);
    this.onToolbarCreatedBinded = null;
    this.createUI();
};

panelExt.prototype.createUI = function () {
    
        var viewer = this.viewer;

        var legandpanel = this.panel;

    // button to show the docking panel
    var toolbarButtonShowDockingPanel = new Autodesk.Viewing.UI.Button('showpanelExt');
    toolbarButtonShowDockingPanel.onClick = function (e) {
        // if null, create it
        if (legandpanel === null) {
            
            
                
            legandpanel = new legands(viewer,viewer.container,'Panel','Smart Plant Data');
        }
        // show/hide docking panel
        legandpanel.setVisible(!legandpanel.isVisible());
        progressClicked = !progressClicked;

        
    };
    
    
   
    toolbarButtonShowDockingPanel.setToolTip('Attributes');

    // SubToolbar
    this.subToolbar = new Autodesk.Viewing.UI.ControlGroup('extToolbar');
    this.subToolbar.addControl(toolbarButtonShowDockingPanel);

    viewer.toolbar.addControl(this.subToolbar);

};

panelExt.prototype.unload = function () {
    this.viewer.toolbar.removeControl(this.subToolbar);
    return true;
};

Autodesk.Viewing.theExtensionManager.registerExtension('panelExt', panelExt);





// legands panel 

function legands(viewer, container, id, title, options) {
    this.viewer = viewer;
    Autodesk.Viewing.UI.DockingPanel.call(this, container, id, title, options);
    
    
    
    this.container.style.top =  "10px";
    this.container.style.left = "10px";
    this.container.style.width = "270px";
    this.container.style.height = "350px";
    this.container.style.resize = "none";



    // this is where we should place the content of our panel

    // and may also append child elements...
    var op = {};
            this.scrollcontainer = this.createScrollContainer(op);
            
            var html = [
                
                '<script>',

'$(document).on("click", ".test", function(event) {',
'var element = $(this);',
    'copyStringToClipboard($(this).html());',
    '$(this).tooltip("show");',
    
    'setTimeout(function(){',
        'element.tooltip("dispose")',
    '}, 500);',
'});',


    '</script>',

'<div class="table-wrapper-scroll-y">',
    '<table id="table" class="table table-dark table-borderless mb-0" style="background:rgba(34,34,34,0.1)">',
  '<thead>',
    '<tr>',
      '<th class="attrname" scope="col">Attribute</th>',
      '<th class="attrvalue" scope="col">Value</th>',
    '</tr>',
  '</thead>',
  '<tbody id = "Mrcode">',
    '</tbody>',
'</table>',
'</div>',
                
].join('\n');


$(this.scrollContainer).append(html);

this.footer = this.createFooter();
$(this.footer).append('<div class="docking-panel-version-label"><a href="http://audwan.info">by Udwan</a></div>');
}


legands.prototype = Object.create(Autodesk.Viewing.UI.DockingPanel.prototype);
legands.prototype.constructor = legands;
